% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{land_geometry}
\alias{land_geometry}
\title{Calculate the Geometric Parameters for Terrestrial Wind}
\usage{
land_geometry(dem, inland_proximity, returnpoints = FALSE)
}
\arguments{
\item{dem}{SpatRaster  object, digital elevation model}

\item{inland_proximity}{SpatRaster  object, distance from the coast inland}

\item{returnpoints}{Return SpatVector of points or SpatRaster}
}
\value{
SpatVector with attributes or SpatRaster\tabular{lll}{
   Abbreviated attribute \tab description \tab units \cr
   dem \tab Digital Elevation Model \tab m \cr
   lat \tab Latitude \tab degs \cr
   lon \tab Longitude \tab degs \cr
   slope \tab slope of terrain \tab - \cr
   aspect \tab DEM aspect \tab - \cr
   inlandD \tab distance inland from coast \tab m \cr
   f \tab Coriolis parameter \tab hz \cr
}
}
\description{
Returns geometric data to compute wind fields.
}
\examples{
require(terra)
dem <- rast(system.file("extdata/DEMs/YASI_dem.tif", package="TCHazaRds"))
land <- dem; land[land > 0] = 0
inland_proximity = distance(land,target = 0)
GEO_land = land_geometry(dem,inland_proximity)
plot(GEO_land)
}
