% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCIApathfinder.R
\name{get_patient_info}
\alias{get_patient_info}
\title{Get patient information}
\usage{
get_patient_info(collection = NULL)
}
\arguments{
\item{collection}{TCIA collection name. If \code{collection} is \code{NULL},
patients from all collections will be returned. To get a list of available collection
names, call \code{\link{get_collection_names}}.}
}
\value{
List containing elements:
\itemize{
  \item \code{patients}: Data frame of patient ID, name, sex, ethnic group, and collection name
  \item \code{content}: parsed API response content
  \item \code{response}: API response
}
}
\description{
Get patient information
}
\examples{
\dontrun{
get_patient_info()
get_patient_info("TCGA-BRCA")
}

}
\seealso{
\code{\link{get_collection_names}},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+Programmatic+Interface+\%28REST+API\%29+Usage+Guide}{TCIA REST API Usage Guide},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+API+Return+Values}{TCIA API object definitions}
}
