"fitModel" <-
function (data, modspec = list(), datasetind = vector(), modeldiffs = list(), 
opt = opt()) 
{
  currModel <- getModel(data, modspec, modeldiffs, datasetind, opt)
  
  tr <- getTheta(currModel)
  theta <- tr$theta
  currModel <- tr$mod
  
  currTheta <- getThetaCl(theta, currModel)
  
  iter <- opt@iter
  
  assign(".currTheta", currTheta, envir = .GlobalEnv)
  assign(".currModel", currModel, envir = .GlobalEnv)
  
  if(opt@algorithm == "nls") {
    
    currModel@fit@nlsres$onls <- nls(~rescomp(t=t,d=d,currModel=currModel),
                                     data=list(d=vector(),currModel=currModel), 
                                     control =
                                     nls.control(maxiter = iter,
                                                 minFactor = opt@minFactor,
                                                 warnOnly = TRUE,
                                                 printEval = TRUE),
                                     start = list(t = theta),
                                     algorithm = opt@nlsalgorithm,
                                     trace = TRUE)
  }
  else if(opt@algorithm == "nls.lm") {
    if(length(opt@parscale)!=0) {
      if(opt@parscale[1] == "abs")
        parscale <- 1/abs(theta)
      else
        parscale <- opt@parscale
      currModel@fit@nlsres$onls <- nls.lm(par=theta, fn = rescomp, 
                                          currModel=currModel,
                                          control=list(nprint=1,
                                            maxiter = iter,maxfev=opt@maxfev,
                                            diag = parscale))
    }
    else
      currModel@fit@nlsres$onls <- nls.lm(par=theta, fn = rescomp, 
                                          currModel=currModel,
                                          control=list(nprint=1,
                                            maxiter = iter,maxfev=opt@maxfev))
  }
  else if(opt@algorithm == "optim") {
    currModel@fit@nlsres$onls <- optim(par=theta, fn = rescomp,
                                       currModel=currModel,
                                       method = opt@optimmethod,
                                       control=list(trace=100,
                                         maxit=iter),
                                       hessian=TRUE)
    
  }
  currModel@finished <- TRUE
  if(opt@algorithm == "nls")
    resFinal <- rescomp(t=currModel@fit@nlsres$onls$m$getPars(),
                          currModel=currModel)
  else 
    resFinal <- rescomp(t=currModel@fit@nlsres$onls$par, currModel=currModel)
  
  currModel <- resFinal$currModel
  currTheta <- resFinal$currTheta
  
  assign(".currTheta", currTheta, envir = .GlobalEnv)
  assign(".currModel", currModel, envir = .GlobalEnv)
  
  if (opt@plot) 
    plotter(currModel@modellist[[1]], currModel, currTheta, opt)

  currModel@optlist[[1]] <- opt
  
  ret <- list(currModel = currModel, currTheta = currTheta)
  
  return(ret)
}
