% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaMDB.R
\name{metaMDB}
\alias{metaMDB}
\alias{names<-.metaMDB}
\alias{rename.metaMDB}
\alias{[.metaMDB}
\alias{[[.metaMDB}
\alias{$.metaMDB}
\title{A metaMDB object}
\usage{
metaMDB(MDBs, relationalTables, dataModel, dbInfo)

\method{names}{metaMDB}(x) <- value

\method{rename}{metaMDB}(.data, ...)

\method{[}{metaMDB}(x, i)

\method{[[}{metaMDB}(x, i)

\method{$}{metaMDB}(x, i)
}
\arguments{
\item{MDBs}{a list of \link{MDB} objects}

\item{relationalTables}{a list of tibbles corresponding to the relational
tables between the different MDBs}

\item{dataModel}{a \link[ReDaMoR:RelDataModel]{ReDaMoR::RelDataModel} object gathering all the
data model of all the MDBs plus the relational tables}

\item{dbInfo}{a list with DB information:
\strong{"name"} (only mandatory field), "title", "description", "url",
"version", "maintainer".}

\item{x}{a \link{metaMDB} object}

\item{value}{new table names}

\item{.data}{a \link{metaMDB} object}

\item{...}{Use new_name = old_name to rename selected tables}

\item{i}{the index or the name of the tables to take}
}
\value{
A metaMDB object
}
\description{
A metaMDB object is an \link{MDB} gathering several other MDBs glued by
relational tables.
}
\seealso{
\itemize{
\item MDB methods:
\link{db_info}, \link{data_model}, \link{data_tables}, \link{collection_members},
\link{count_records}, \link{filter_with_tables}, \link{as_fileMDB}
\item Additional general documentation is related to \link{MDB}.
\item \link{filter.metaMDB}, \link{slice.metaMDB}
\item \link{get_confrontation_report}, \link[ReDaMoR:format_confrontation_report]{ReDaMoR::format_confrontation_report}
and \link[ReDaMoR:format_confrontation_report_md]{ReDaMoR::format_confrontation_report_md} for getting and formatting
the report confronting the data to the model.
}
}
