% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chMDB.R, R/fileMDB.R, R/generics.R,
%   R/memoMDB.R, R/metaMDB.R
\name{dims.chMDB}
\alias{dims.chMDB}
\alias{dims.fileMDB}
\alias{dims}
\alias{dims.memoMDB}
\alias{dims.metaMDB}
\title{Detailed information about the format of the tables}
\usage{
\method{dims}{chMDB}(x, ...)

\method{dims}{fileMDB}(
  x,
  ...,
  by = 1000,
  estimateThr = 5e+07,
  estimateSample = 10^6,
  showWarnings = TRUE
)

dims(x, ...)

\method{dims}{memoMDB}(x, ...)

\method{dims}{metaMDB}(x, ...)
}
\arguments{
\item{x}{an object with embedded data tables}

\item{...}{the name of the tables to consider (default: all of them)}

\item{by}{the size of the batch: number of lines to count
together (default: 1000)}

\item{estimateThr}{file size threshold in bytes from which an estimation
of row number should be computed instead of a precise count
(default: 50000000 = 50MB)}

\item{estimateSample}{number of values on which the estimation is based
(default: 10^6)}

\item{showWarnings}{a warning is raised by default if estimation is done.}
}
\value{
A tibble with one row for each considered table and the
following columns:
\itemize{
\item name: the name of the table
\item format: "table" or "matrix"
\item ncol: number of columns
\item nrow: number of rows
\item records: number of records (\code{nrow} for tables and \code{ncol*nrow} for matrices)
\item transposed: FALSE by default. TRUE only for matrices stored in a
transposed format.
}
}
\description{
Detailed information about the format of the tables
}
