% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.parameters.R
\name{as.parameters}
\alias{as.parameters}
\alias{as.parameters.data.frame}
\alias{as.parameters.list}
\alias{as.parameters.matrix}
\alias{as.parameters.numeric}
\title{as.parameters - converting parameter-vectors to a parameters-objects}
\usage{
as.parameters(..., distr = NULL)

\method{as.parameters}{numeric}(..., distr)

\method{as.parameters}{matrix}(x, distr, ...)

\method{as.parameters}{list}(x, distr, ...)

\method{as.parameters}{data.frame}(x, formula, distr, ...)
}
\arguments{
\item{...}{parameters of distribution}

\item{distr}{character giving the distribution. Function of name
q\"distr\" has to be available.}

\item{x}{numeric vector, matrix, list, or data.frame of parameters.}

\item{formula}{if \code{x} is data.frame a formula has to be given.}
}
\value{
Named vector of parameters of class parameters. Distribution and
q-function are given as attributes.
}
\description{
Converting parameter-vectors to parameters-objects
}
\section{Methods (by class)}{
\itemize{
\item \code{numeric}: as.parameters for numeric data vectors

\item \code{matrix}: as.parameters for numeric data matrices

\item \code{list}: as.parameters for numeric data lists

\item \code{data.frame}: as.parameters for numeric data.frames
}}
\examples{
library(evd)
as.parameters(loc = 3, scale = 2, shape = .4, distr = "gev")
as.parameters(c(loc = 3, scale = 2, shape = .4), distr = "gev")

as.parameters(cbind(loc = 10, scale = 4, shape = seq(0, .4, .1)), distr = "gev")
as.parameters(rbind(loc = 10, scale = 4, shape = seq(0, .4, .1)), distr = "gev")
#as.parameters(matrix(1:9, nr = 3), distr = "gev") # doesn't work!

as.parameters(list(list(mean = 2, sd = 1), list(mean = 0, sd = 1)), distr = "norm")
as.parameters(list(c(mean = 2, sd = 1), c(mean = 0, sd = 1)), distr = "norm")

xdat <- data.frame(station = c(1, 2), mean = c(2, 0), sd = c(1, 1))
as.parameters(xdat, cbind(mean, sd) ~ station, distr = "norm")
as.parameters(xdat, . ~ station, distr = "norm")
as.parameters(xdat, cbind(mean, sd) ~ ., distr = "norm")

quantiles(as.parameters(xdat, cbind(mean, sd) ~ ., distr = "norm"), c(.99))

# Quantilberechnung
p <- as.parameters(loc = 3, scale = 2, shape = .4, distr = "evd::gev")
quantiles(p, c(.9, .95))
p <- as.parameters(cbind(loc = 10, scale = 4, shape = seq(0, .4, .1)), distr = "evd::gev")
quantiles(p, c(.9, .95))
p <- as.parameters(list(list(mean = 2, sd = 1), list(mean = 0, sd = 1)), distr = "norm")
quantiles(p, c(.95, .975))

# Mit magrittr
library(magrittr)
as.parameters(loc = 3, scale = 2, shape = .4, distr = "gev") \%>\% quantiles(c(.9, .99))
}

