% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_align.peaks.R
\name{plot_align.peaks}
\alias{plot_align.peaks}
\title{Plots mod_alignPeaks results}
\usage{
plot_align.peaks(temperatures, old.TL, new.TL, ref.TL, pos.peak,
  plotting.parameters = list(plot.Tmin = 0, plot.Tmax = NA))
}
\arguments{
\item{temperatures}{\link{numeric}: Vector containing the temperature step}

\item{old.TL}{\link{numeric}: Matrix containing the luminescence signal before the peak alignment.}

\item{new.TL}{\link{numeric}: Matrix containing the luminescence signal after the peak alignment.}

\item{ref.TL}{\link{numeric}: Matrix containing the luminescence signal used as reference to define the peak position.}

\item{pos.peak}{\link{numeric}: Average peak position.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}
}
\description{
This function plots the results obtained by mod_alignPeaks.
}
\details{
\bold{Plotting parameters} \cr
 The plotting parameters are:  \cr
 \describe{
 \item{\code{plot.Tmin}}{
   \link{logical}: Minimum temperature which is plotted.}
 \item{\code{plot.Tmax}}{
   \link{logical}: Maximum temperature which is plotted.}
}
}
\author{
David Strebler
}
\seealso{
\link{mod_align.peaks}
}

