% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_cor.R
\name{compare_cor}
\alias{compare_cor}
\title{Comparing two independent correlation coefficients}
\usage{
compare_cor(r1, df1, r2, df2, alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{r1}{Correlation study 1.}

\item{df1}{Degrees of freedom from study 1 (if a simple correlation the df is N-2).}

\item{r2}{Correlation study 2.}

\item{df2}{Degrees of freedom from study 2 (if a simple correlation the df is N-2).}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less". You can specify just the initial letter.
 @return A list with class "htest" containing the following components:
\describe{
  \item{\code{"statistic"}}{z-score}
  \item{\code{"p.value"}}{numeric scalar containing the p-value for the test under the null hypothesis.}
  \item{\code{"estimate"}}{difference in SMD between studies}
  \item{\code{"null.value"}}{the specified hypothesized value for the null hypothesis.}
  \item{\code{"alternative"}}{character string indicating the alternative hypothesis (the value of the input argument alternative). Possible values are "greater", "less", or "two-sided".}
  \item{\code{"method"}}{Type of SMD}
  \item{\code{"data.name"}}{"Summary Statistics" to denote summary statistics were utilized to obtain results.}
  \item{\code{"cor"}}{Correlation input for the function.}
  \item{\code{"call"}}{the matched call.}
}}
}
\description{
A function to compare correlations between studies. This function is intended to be used to compare the compatibility of original studies with replication studies (lower p-values indicating lower compatibility).
}
