% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatostr.h.R
\name{dataTOSTr}
\alias{dataTOSTr}
\title{TOST Correlation}
\usage{
dataTOSTr(
  data,
  pairs,
  cor_type = "pearson",
  hypothesis = "EQU",
  low_eqbound_r = -0.3,
  high_eqbound_r = 0.3,
  alpha = 0.05,
  desc = FALSE,
  plots = FALSE
)
}
\arguments{
\item{data}{the data as a data frame}

\item{pairs}{a list of vectors of strings naming variables to correlate
from \code{data}}

\item{cor_type}{a character string indicating which correlation coefficient
is to be used for the test. One of "pearson", "kendall", or "spearman", can
be abbreviated.}

\item{hypothesis}{\code{'EQU'} for equivalence (default), or \code{'MET'}
for minimal effects test, the alternative hypothesis.}

\item{low_eqbound_r}{lower equivalence bounds (e.g., -0.3) expressed in a
correlation effect size}

\item{high_eqbound_r}{upper equivalence bounds (e.g., 0.3) expressed in a
correlation effect size}

\item{alpha}{alpha level (default = 0.05)}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide plots}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$text} \tab \tab \tab \tab \tab a preformatted \cr
  \code{results$tost} \tab \tab \tab \tab \tab a table \cr
  \code{results$desc} \tab \tab \tab \tab \tab a table \cr
  \code{results$plots} \tab \tab \tab \tab \tab an array of images \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$tost$asDF}

\code{as.data.frame(results$tost)}
}
\description{
TOST for correlations in jamovi. This function is not meant to be utilized 
in R.
}
