% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.TOSTnp.R
\name{TOSTnp-methods}
\alias{TOSTnp-methods}
\alias{print.TOSTnp}
\alias{describe.TOSTnp}
\title{Methods for TOSTnp objects}
\usage{
\method{print}{TOSTnp}(x, digits = 4, ...)

\method{describe}{TOSTnp}(x, digits = 3, ...)
}
\arguments{
\item{x}{object of class \code{TOSTnp}.}

\item{digits}{Number of digits to print for p-values}

\item{...}{further arguments passed through, see description of return value
for details.
\link{TOSTnp-methods}.}
}
\value{
\itemize{
\item print: Prints short summary of the tests.
\item describe: Verbose description of results.
}
}
\description{
Methods defined for objects returned from the wilcox_TOST function.
}
\examples{
# example code
data(mtcars)
res1 = wilcox_TOST(mpg ~ am,data = mtcars,eqb = 3)

# PRINT
print(res1)

# DESCRIPTION
describe(res1)
}
