% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsne_plot.R
\name{tsne_plot}
\alias{tsne_plot}
\title{TSNE plot for analyzing and visualizing TSNE algorithm.}
\usage{
tsne_plot(
  data,
  point_size = 3,
  point_alpha = 0.8,
  text_size = 2,
  text_alpha = 0.8,
  ci_level = 0.95,
  ellipse_alpha = 0.3,
  sci_fill_color = "Sci_AAAS",
  sci_color_alpha = 0.9,
  legend_pos = "right",
  legend_dir = "vertical",
  ggTheme = "theme_light"
)
}
\arguments{
\item{data}{Dataframe: include columns (IDs, Trait1, Trait2, ...).}

\item{point_size}{Numeric: point size. Default: 3, min: 0, max: null.}

\item{point_alpha}{Numeric: point color alpha. Default: 0.80, min: 0.00, max: 1.00.}

\item{text_size}{Numeric: text size. Default: 2, min: 0 (hind), max: null.}

\item{text_alpha}{Numeric: text alpha. Default: 0.80, min: 0.00, max: 1.00.}

\item{ci_level}{Numeric: confidence interval level. Default: 0.95, min: 0.00, max: 1.00.}

\item{ellipse_alpha}{Numeric: ellipse alpha. Default: 0.30, min: 0.00, max: 1.00.}

\item{sci_fill_color}{Character: ggsci color pallet. Default: "Sci_AAAS", options: "Sci_AAAS", "Sci_NPG", "Sci_Simpsons", "Sci_JAMA", "Sci_GSEA", "Sci_Lancet", "Sci_Futurama", "Sci_JCO", "Sci_NEJM", "Sci_IGV", "Sci_UCSC", "Sci_D3", "Sci_Material".}

\item{sci_color_alpha}{Numeric: ggsci border color alpha. Default: 1.00, min: 0.00, max: 1.00.}

\item{legend_pos}{Character: legend position. Default: "right", options: "none", "left", "right", "bottom", "top".}

\item{legend_dir}{Character: legend direction. Default: "vertical", options: "horizontal", "vertical".}

\item{ggTheme}{Character: ggplot2 themes. Default: "theme_light", options: "theme_default", "theme_bw", "theme_gray", "theme_light", "theme_linedraw", "theme_dark", "theme_minimal", "theme_classic", "theme_void"}
}
\value{
Plot: TSNE plot for analyzing and visualizing TSNE algorithm.
}
\description{
TSNE plot for analyzing and visualizing TSNE algorithm.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(tsne_data)

# 3. Default parameters
tsne_plot(tsne_data)

# 4. Set point_alpha = 0.50
tsne_plot(tsne_data, point_alpha = 0.50)

# 5. Set sci_fill_color = "Sci_NPG"
tsne_plot(tsne_data, sci_fill_color = "Sci_NPG")

}
\author{
benben-miao
}
