% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go_enrich_net.R
\name{go_enrich_net}
\alias{go_enrich_net}
\title{GO enrichment analysis and net plot (None/Exist Reference Genome).}
\usage{
go_enrich_net(
  go_anno,
  degs_list,
  padjust_method = "fdr",
  pvalue_cutoff = 0.05,
  qvalue_cutoff = 0.05,
  category_num = 20,
  net_layout = "circle",
  net_circular = TRUE,
  low_color = "#ff0000aa",
  high_color = "#008800aa"
)
}
\arguments{
\item{go_anno}{Dataframe: GO and KEGG annotation of background genes (1st-col: Genes, 2nd-col: biological_process, 3rd-col: cellular_component, 4th-col: molecular_function, 5th-col: kegg_pathway).}

\item{degs_list}{Dataframe: degs list.}

\item{padjust_method}{Character: P-value adjust to Q-value. Default: "fdr" (false discovery rate), options: "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none".}

\item{pvalue_cutoff}{Numeric: P-value cutoff. Recommend: small than 0.05.}

\item{qvalue_cutoff}{Numeric: Q-value cutoff. Recommend: small than 0.05.}

\item{category_num}{Numeric: categories number to display. Default: 20, min: 1, max: NULL.}

\item{net_layout}{Character: network layout. Default: "circle", options: 'star', 'circle', 'gem', 'dh', 'graphopt', 'grid', 'mds', 'randomly', 'fr', 'kk', 'drl' or 'lgl'.}

\item{net_circular}{Logical: network circular. Default: TRUE, options: TRUE, FALSE.}

\item{low_color}{Character: low value (p-value or q-value) color (color name or hex value).}

\item{high_color}{Character: high value (p-value or q-value) color (color name or hex value).}
}
\value{
PLot: GO enrichment analysis and net plot (None/Exist Reference Genome).
}
\description{
GO enrichment analysis and net plot (None/Exist Reference Genome).
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(gene_go_kegg)
head(gene_go_kegg)

# 3. Default parameters
go_enrich_net(gene_go_kegg[,-5], gene_go_kegg[100:200,1])

}
\author{
benben-miao
}
