% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TSMining.R
\docType{data}
\name{test}
\alias{test}
\title{An example data set for univariate motif discovery}
\format{A data frame with 100 rows and 2 variables}
\usage{
data(test)
}
\description{
The data is a data frame containing 100 observations and 2 variables.
The first time series is denoted as TS1. It is created in such a way that two motifs are embedded,
each with two appearances and a length of 10. The rest are randomly generated.
The second time series is denoted as TS2. It is created in such a way that one motif with three appearances are embedded.
It has a length of 20. The rest are randomly generated.
This synthetic data set is used as examples for motif discovery
}
\examples{
library(ggplot2)
data(test)
ggplot(data = test, aes(x = 1:dim(test)[1], y = TS1)) + geom_line() + geom_point()
ggplot(data = test, aes(x = 1:dim(test)[1], y = TS2)) + geom_line() + geom_point()
}
\keyword{datasets}

