#' US Monthly Total Vehicle Sales
#' 
#' US monthly total vehicle sales: 1976 - 2017.
#' Units: Thousands of units
#' 
#' 
#' @format Time series data - 'ts' object
#' @source U.S. Bureau of Economic Analysis, Total Vehicle Sales [TOTALNSA], retrieved from FRED, Federal Reserve Bank of St. Louis; https://fred.stlouisfed.org/series/TOTALNSA, January 7, 2018.
#' @keywords datasets
#' @examples
#' ts.plot_ly(USVSales)
#' seasonal_ly(USVSales)

"USVSales"

#' US Monthly Civilian Unemployment Rate
#' 
#' US monthly civilian unemployment rate: 1948 - 2017.
#' Units: Percent
#' 
#' @format Time series data - 'ts' object
#' @source U.S. Bureau of Labor Statistics, Civilian Unemployment Rate [UNRATENSA], retrieved from FRED, Federal Reserve Bank of St. Louis; https://fred.stlouisfed.org/series/UNRATENSA, January 6, 2018.
#' @keywords datasets
#' @examples
#' ts.plot_ly(USUnRate)
#' seasonal_ly(USUnRate)

"USUnRate"



#' US monthly natural gas consumption
#' 
#' US monthly natural gas consumption: 2000 - 2017.
#' Units: Billion Cubic Feet
#' 
#' @format Time series data - 'ts' object
#' @source U.S. Bureau of Transportation Statistics, Natural Gas Consumption [NATURALGAS], retrieved from FRED, Federal Reserve Bank of St. Louis; https://fred.stlouisfed.org/series/NATURALGAS, January 7, 2018.
#' @keywords datasets
#' @examples
#' ts.plot_ly(USgas)
#' seasonal_ly(USgas)

"USgas"

#' University of Michigan Consumer Survey, Index of Consumer Sentiment
#' 
#' University of Michigan Consumer Survey, Index of Consumer Sentiment: 1980 - 2017.
#' Units: Index 1966:Q1=100
#' 
#' @format Time series data - 'xts' object
#' @source University of Michigan, University of Michigan: Consumer Sentiment
#' @keywords datasets
#' @examples
#' ts.plot_ly(Michigan_CS)
#' seasonal_ly(Michigan_CS)

"Michigan_CS"


#' Crude Oil Prices: Brent - Europe
#' 
#' Crude Oil Prices: Brent - Europe: 1987 - 2017.
#' Units: Dollars per Barrel
#' 
#' @format Time series data - 'zoo'
#' @source U.S. Energy Information Administration, Crude Oil Prices: Brent - Europe [MCOILBRENTEU], retrieved from FRED, Federal Reserve Bank of St. Louis; https://fred.stlouisfed.org/series/MCOILBRENTEU, January 8, 2018.
#' @keywords datasets
#' @examples
#' ts.plot_ly(EURO_Brent)
#' seasonal_ly(EURO_Brent)

"EURO_Brent"