% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_seasonal.R
\name{ts_seasonal}
\alias{ts_seasonal}
\alias{seasonal_ly}
\title{Seasonality Visualization of Time Series Object}
\usage{
ts_seasonal(ts.obj, type = "normal", Ygrid = FALSE, Xgrid = FALSE)
}
\arguments{
\item{ts.obj}{a univariate time series object of a class "ts", "zoo" or "xts" (support only series with either monthly or quarterly frequency)}

\item{type}{The type of the seasonal plot - 
"normal" to split the series by full cycle units, or
"cycle" to split by cycle units, or
"box" for box-plot by cycle units, or
"all" for all the three plots together}

\item{Ygrid}{logic,show the Y axis grid if set to TRUE}

\item{Xgrid}{logic,show the X axis grid if set to TRUE}
}
\description{
Visualize time series object by it periodicity, currently support only monthly and quarterly frequency
}
\examples{
data(USgas)
ts_seasonal(USgas)

# Seasonal box plot
ts_seasonal(USgas, type = "box") 
}
