% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_seasonal.R
\name{ts_ma}
\alias{ts_ma}
\title{Moving Average Method for Time Series Data}
\usage{
ts_ma(ts.obj, n = c(3, 6, 9), n_left = NULL, n_right = NULL,
  double = NULL, plot = TRUE, show_legend = TRUE, multiple = FALSE,
  separate = TRUE, margin = 0.03, title = NULL, Xtitle = NULL,
  Ytitle = NULL)
}
\arguments{
\item{ts.obj}{a univariate time series object of a class "ts", "zoo" or "xts" (support only series with either monthly or quarterly frequency)}

\item{n}{A single or multiple integers (by default using 3, 6, and 9 as inputs), 
define a two-sides moving averages by setting the number of past and future to use 
in each moving average window along with current observation.}

\item{n_left}{A single integer (optional argument, default set to NULL), can be used, 
along with the n_right argument, an unbalanced moving average. 
The n_left defines the number of lags to includes in the moving average.}

\item{n_right}{A single integer (optional argument, default set to NULL), can be used, 
along with the n_left argument, to set an unbalanced moving average. 
The n_right defines the number of negative lags to includes in the moving average.}

\item{double}{A single integer, an optional argument. If not NULL (by default), will apply a second moving average process on the initial moving average output}

\item{plot}{A boolean, if TRUE will plot the results}

\item{show_legend}{A boolean, if TRUE will show the plot legend}

\item{multiple}{A boolean, if TRUE (and n > 1) will create multiple plots, one for each moving average degree. By default is set to FALSE}

\item{separate}{A boolean, if TRUE will separate the orignal series from the moving average output}

\item{margin}{A numeric, set the plot margin when using the multiple or/and separate option, default value is 0.03}

\item{title}{A character, if not NULL (by default), will use the input as the plot title}

\item{Xtitle}{A character, if not NULL (by default), will use the input as the plot x - axis title}

\item{Ytitle}{A character, if not NULL (by default), will use the input as the plot y - axis title}
}
\value{
A list with the original series, the moving averages outputs and the plot
}
\description{
Calculate the moving average (and double moving average) for time series data
}
\details{
A one-side moving averages (also known as simple moving averages) calculation for Y[t] (observation Y of the series at time t):

MA[t|n] = (Y[t-n] + Y[t-(n-1)] +...+ Y[t]) / (n + 1), 

where n defines the number of consecutive observations to be used on each rolling window along with the current observation 

Similarly, a two-sided moving averages with an order of (2*n + 1) for Y[t]:

MA[t|n] = (Y[t-n] + Y[t-(n-1)] +...+ Y[t] +...+ Y[t+(n-1)] + Y[t+n]) / (2*n + 1)

Unbalanced moving averages with an order of (k1 + k2 + 1) for observation Y[t]:

MA[t|k1 & k2] = (Y[t-k1] + Y[t-(k1-1)] +...+ Y[t] +...+ Y[t+(k2-1)] + Y[t+k2]) / (k1 + k2 + 1)

The unbalanced moving averages is a special case of two-sides moving averages, 
where k1 and k2 represent the number of past and future periods, 
respectively to be used in each rolling window, and k1 != k2 
(otherwise it is a normal two-sided moving averages function)
}
\examples{
\dontrun{
# A one-side moving average order of 7
USgas_MA7 <- ts_ma(USgas, n_left = 6, n = NULL)

# A two-sided moving average order of 13
USgas_two_side_MA <- ts_ma(USgas, n = 6)

# Unbalanced moving average of order 12
 USVSales_MA12 <- ts_ma(USVSales, n_left = 6, n_right = 5, n = NULL, 
 title = "US Monthly Total Vehicle Sales - MA", 
 Ytitle = "Thousand of Units")

# Adding double MA of order 2 to balanced the series:
USVSales_MA12 <- ts_ma(USVSales, n_left = 6, n_right = 5, n = NULL, 
 double = 2,
 title = "US Monthly Total Vehicle Sales - MA", 
 Ytitle = "Thousand of Units")

# Adding several types of two-sided moving averages along with the unblanced
# Plot each on a separate plot
USVSales_MA12 <- ts_ma(USVSales, n_left = 6, n_right = 5, n = c(3, 6, 9), 
double = 2, multiple = TRUE,
title = "US Monthly Total Vehicle Sales - MA", 
Ytitle = "Thousand of Units")
}
}
