% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_plot.R
\name{ts_plot}
\alias{ts_plot}
\title{Plotting Time Series Objects}
\usage{
ts_plot(ts.obj, line.mode = "lines", width = 2, dash = NULL,
  color = NULL, slider = FALSE, type = "multiple", Xtitle = NULL,
  Ytitle = NULL, title = NULL, Xgrid = FALSE, Ygrid = FALSE)
}
\arguments{
\item{ts.obj}{A univariate or multivariate time series object of class "ts", "mts", "zoo", "xts", or any data frame object with 
a minimum of one numeric column and either a Date or POSIXt class column}

\item{line.mode}{A plotly argument, define the plot type, c("lines", "lines+markers", "markers")}

\item{width}{An Integer, define the plot width, default is set to 2}

\item{dash}{A plotly argument, define the line style, c(NULL, "dot", "dash")}

\item{color}{The color of the plot, support both name and expression}

\item{slider}{Logic, add slider to modify the time axis (default set to FALSE)}

\item{type}{Applicable for multiple time series object, plot on a separate plot or all together c("single, "multiple)}

\item{Xtitle}{A character, set the X axis title, default set to NULL}

\item{Ytitle}{A character, set the Y axis title, default set to NULL}

\item{title}{A character, set the plot title, default set to NULL}

\item{Xgrid}{Logic,show the X axis grid if set to TRUE}

\item{Ygrid}{Logic,show the Y axis grid if set to TRUE}
}
\description{
Visualization functions for time series object
}
\examples{
data(USVSales)
ts_plot(USVSales)

# adding slider
ts_plot(USVSales, slider = TRUE)
}
