% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Vol.r
\name{Vfm}
\alias{Vfm}
\alias{Efm}
\alias{VolR}
\alias{VolE}
\alias{VolFAO}
\alias{Vfm_phys}
\alias{Efm_phys}
\title{tree volume information}
\usage{
Vfm(obj)

Efm(obj, stH = 0.01)

VolR(obj)

VolE(obj)

VolFAO(obj)

Vfm_phys(obj)

Efm_phys(obj, stH = 0.01)
}
\arguments{
\item{obj}{a object of class 'tprTrees'}

\item{stH}{assumed or known relative or absolute stump height, from which
volume calculation should starts, defaults to 0.01}
}
\value{
vector of volume estimates
}
\description{
Wrapper to get specific type of volume from taper curve
}
\details{
wrapper functions around \code{\link{tprVolume}}, which return
specific definitions of stem volume.

Function \code{Efm} uses parameter \code{stH} to define starting
point, i.e. stump height, of volume calculation. \code{stH} can be defined
relative to total tree height \code{(0 < stH <= 1)} or in absolute measure
(unit=cm) in case \code{stH > 1}

\code{VolE} calculates as the sum of volume of default assortments
 (stem wood, top log, industrial wood, X-wood, non-usuable wood according to
 RVR. For dbh < 7cm a linear regression is applied.

\code{VolFAO} calculates tree volume starting from stump up to tree
top (in contrast to german definition, which uses D=7cm over bark), and
includes bark component. Stump height is defined as 1\% of tree height.
Volume calculation is based on 2m-sections. For trees with dbh < 7cm,
tabulated values are used, see Riedel et al. (2017) for details (e.g. p.35,
table 5.6).

\code{Vfm_phys} is equal to \code{Vfm}, except that the taper curve
is numerically integrated, by use of section length of 0.01m. This is
relevant if biomass or nutrient export is to be calculate. Numerical
integration is quite slow.

\code{Efm_phys} is equal to \code{Efm}, except that the taper curve
is numerically integrated, by use of section length of 0.01m. This is
relevant if biomass or nutrient export is to be calculate. Numerical
integration is quite slow.
}
\section{Functions}{
\itemize{
\item \code{Efm()}: Efm, i.e. coarse wood excl. bark from Ht=stH*Ht to Dob=7cm

\item \code{VolR()}: VolR: Volume from H=0 to D=7cm over bark, measured as 2m sections

\item \code{VolE()}: VolE: sum of volume of default assortments according to RVR

\item \code{VolFAO()}: VolFAO: from stump to tree top incl. bark; if dbh < 7cm using
tabulated values

\item \code{Vfm_phys()}: Vfm_phys physical volume of tree incl. bark from A=0

\item \code{Efm_phys()}: Efm_phys physical volume of tree excl. bark from A=0.1*Ht

}}
\examples{
t <- tprTrees() # constructor of class 'tprTrees'
Vfm(t)
Efm(t)
Efm(t, stH=0.01) # stump height = 1\\% of tree height
Efm(t, stH=10) # stump height=10cm
VolR(t)
VolE(t)
VolFAO(t)
Vfm_phys(t) # slower since much more evaluations of taper curve (every 1 cm)
Efm_phys(t, stH=0.01) # slower since much more evaluations of taper curve (every 1 cm)
}
\references{
\href{https://www.bundeswaldinventur.de/fileadmin/SITE_MASTER/content/Downloads/BWI_Methodenband_web.pdf}{Riedel, T. and Hennig, P. and Kroiher, F. and Polley, H. and
Schwitzgebel, F. (2017): Die dritte Bundeswaldinventur (BWI 2012). Inventur-
und Auswertemethoden. 124 pages.}
}
