# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

HoeffIndCdfRCPP <- function(x, maxError) {
    .Call('TauStar_HoeffIndCdfRCPP', PACKAGE = 'TauStar', x, maxError)
}

HoeffIndPdfRCPP <- function(x, maxError) {
    .Call('TauStar_HoeffIndPdfRCPP', PACKAGE = 'TauStar', x, maxError)
}

#' Eigenvalues for discrete asymptotic distribution
#'
#' Computes the eigenvalues needed to determine the asymptotic distributions
#' in the mixed/discrete cases. See Nandy, Weihs, and Drton (2016)
#' <http://arxiv.org/abs/1602.04387> for more details.
#'
#' @export
#'
#' @param p a vector of probabilities that sum to 1.
#'
#' @return the eigenvalues associated to the matrix generated by p
eigenForDiscreteProbs <- function(p) {
    .Call('TauStar_eigenForDiscreteProbs', PACKAGE = 'TauStar', p)
}

HoeffIndDiscreteCdfRCPP <- function(x, eigenP, eigenQ, maxError) {
    .Call('TauStar_HoeffIndDiscreteCdfRCPP', PACKAGE = 'TauStar', x, eigenP, eigenQ, maxError)
}

HoeffIndDiscretePdfRCPP <- function(x, eigenP, eigenQ, maxError) {
    .Call('TauStar_HoeffIndDiscretePdfRCPP', PACKAGE = 'TauStar', x, eigenP, eigenQ, maxError)
}

HoeffIndMixedCdfRCPP <- function(x, eigenP, maxError) {
    .Call('TauStar_HoeffIndMixedCdfRCPP', PACKAGE = 'TauStar', x, eigenP, maxError)
}

HoeffIndMixedPdfRCPP <- function(x, eigenP, maxError) {
    .Call('TauStar_HoeffIndMixedPdfRCPP', PACKAGE = 'TauStar', x, eigenP, maxError)
}

TStarFastTiesRCPP <- function(xNumeric, yNumeric) {
    .Call('TauStar_TStarFastTiesRCPP', PACKAGE = 'TauStar', xNumeric, yNumeric)
}

VTStarFastTiesRCPP <- function(xNumeric, yNumeric) {
    .Call('TauStar_VTStarFastTiesRCPP', PACKAGE = 'TauStar', xNumeric, yNumeric)
}

TStarFastResampleRCPP <- function(xNumeric, yNumeric, numResamples, sampleSize) {
    .Call('TauStar_TStarFastResampleRCPP', PACKAGE = 'TauStar', xNumeric, yNumeric, numResamples, sampleSize)
}

TStarSlowTiesRCPP <- function(x, y, vStat) {
    .Call('TauStar_TStarSlowTiesRCPP', PACKAGE = 'TauStar', x, y, vStat)
}

