% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogLik.R
\name{survLogLik}
\alias{survLogLik}
\title{Survival Distribution Log Likelihood}
\usage{
survLogLik(time, status, dist, theta, log.scale = T)
}
\arguments{
\item{time}{Observation times.}

\item{status}{Status indicator, coded as 1 if an event was observed, 0 if censored.}

\item{dist}{Distribution.}

\item{theta}{List of parameters, which will vary according to the distribution.}

\item{log.scale}{Are positive parameters on log-scale?}
}
\value{
Scalar value of the log likelihood.
}
\description{
Evaluation of the log-likelihood for parametric survival distribution.
}
\examples{
\dontrun{
# Simulate
D = rWeibull(n=1e3,a=2,l=2,p=0.2);
# Log likelihood
ll = survLogLik(time=D$time,status=D$status,
dist="weibull",theta=list("a"=2,"l"=2),log.scale=F);
}
}
