% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.tsglm.R
\name{summary.tsglm}
\alias{summary.tsglm}
\title{Summarizing Second-order Tensor Generalized Regression Fits}
\usage{
\method{summary}{tsglm}(object, ...)
}
\arguments{
\item{object}{an object of class \kbd{"tsglm"}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\kbd{summary.tsglm} returns a printout similar to \code{\link[stats]{summary.glm}}.

The printout contains the following components:

\kbd{Call}: The formula for fitted model.

\kbd{Deviance Residuals}: The summary statistics of deviance residuals. Provide for model
except \kbd{family = "gaussian"}.

\kbd{Residuals}: The summary statistics of residuals. Provide for \kbd{family = "gaussian"}.

\kbd{Coefficients}: The coefficient table includes estimation, standard deviation,
test statistics, and p-value of parameters and significance stars.

\kbd{Deviance}: The deviance of a fitted model. Provide for model except \kbd{family = "gaussian"}.

\kbd{AIC}: Akaike information criterion.
}
\description{
\kbd{summary} method for self-defined class \kbd{"tsglm"}.
}
\details{
\kbd{summary.tsglm} is combined with \code{\link[base]{print}} to provide
formatting the coefficients, standard errors, etc. and additionally gives 'significance stars'
}
\examples{
# Simulation data
n <- 500 # number of observations
n_P <- 3; n_G <- 64 # dimension of 3-D tensor variables.
n_d <- 2 # number of numerical variable, if n_d == 1,  numerical variable equals to intercept.
beta_True <- rep(1, n_d)
B_True <- c(1,1,1)\%*\%t(rnorm(n_G)) + c(0, .5, .5)\%*\%t(rnorm(n_G))
B_True <- B_True / 10
W <- matrix(rnorm(n*n_d), n, n_d); W[,1] <- 1
W_named <- W
colnames(W_named) <- paste0("w", 1:ncol(W_named))
X <- array(rnorm(n*n_P*n_G), dim=c(n_P, n_G, n))
X_named <- X
dimnames(X_named) <- list(paste0("R", 1:nrow(X_named)),paste0("C", 1:ncol(X_named)))
## Regression
y_R <- as.vector(W\%*\%beta_True + X\%hp\%B_True + rnorm(n))
DATA_R <- list(y = y_R, X = X, W = W)
y_R_named <- as.vector(W_named\%*\%beta_True + X_named\%hp\%B_True + rnorm(n))
DATA_R_named <- list(y = y_R_named, X = X_named, W = W_named)
## Binomial
p_B <- exp(W\%*\%beta_True + X\%hp\%B_True); p_B <- p_B/(1+p_B)
y_B <- rbinom(n, 1, p_B)
DATA_B <- list(y = y_B, W = W, X = X)
## Poisson
p_P <- exp(W\%*\%beta_True + X\%hp\%B_True)
y_P <- rpois(n, p_P)
y_P[which(y_P > 170)] <- 170 # If y_P > 170, factorial(y_P) == inf.
DATA_P <- list(y = y_P, W = W, X = X)

# Execution
## Regression
result_R <- tensorReg2D(y = DATA_R$y, X = DATA_R$X, W=NULL, n_R = 1, family = "gaussian",
opt = 1, max_ite = 100, tol = 10^(-7) )
summary(result_R)
head(predict(result_R, DATA_R$X))

## Regression with specified names
result_R_named <- tensorReg2D(y = DATA_R_named$y, X = DATA_R_named$X, W=DATA_R_named$W,
n_R = 1, family = "gaussian", opt = 1, max_ite = 100, tol = 10^(-7) )
summary(result_R_named)

## Binomial
result_B <- tensorReg2D(y = DATA_B$y, X = DATA_B$X, W=NULL, n_R = 1, family = "binomial",
opt = 1, max_ite = 100, tol = 10^(-7) )
summary(result_B)
head(predict(result_B, DATA_B$X))

## Poisson
result_P <- tensorReg2D(y = DATA_P$y, X = DATA_P$X, W=NULL, n_R = 1, family = "poisson",
opt = 1, max_ite = 100, tol = 10^(-7) )
summary(result_P)
head(predict(result_P, DATA_P$X))

}
\seealso{
\code{\link[base]{summary}, \link{predict.tsglm}}
}
\author{
Mark Chen
}
