% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{theta_EB}
\alias{theta_EB}
\title{Calculate an empirical Bayes estimate of theta for one examinee}
\usage{
theta_EB(nx, theta_init, theta_prop, item_parm, resp, ncat, model, prior,
  prior_parm)
}
\arguments{
\item{nx}{The number of MCMC draws.}

\item{theta_init}{A value for initial estimate of theta.}

\item{theta_prop}{SD of the proposal distribution.}

\item{item_parm}{A numeric matrix of item parameters.}

\item{resp}{A numeric vector of item responses.}

\item{ncat}{A numeric vector of the number of response categories by item.}

\item{model}{A numeric vector indicating the IRT models of each item (1: 1PL, 2: 2PL, 3: 3PL, 4: PC, 5: GPC, 6: GR).}

\item{prior}{The type of prior distribution (1: normal, 2: uniform).}

\item{prior_parm}{A numeric vector of hyperparameters for the prior distribution, c(mu, sigma) or c(ll, ul).}
}
\description{
Calculate an empirical Bayes estimate of theta for one examinee.
}
