% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\name{loadItemAttrib}
\alias{loadItemAttrib}
\title{Load item attributes}
\usage{
loadItemAttrib(file, pool)
}
\arguments{
\item{file}{Character. The name of the file containing item attributes.}

\item{pool}{An \code{\linkS4class{item_pool}} object. Use \code{\link{loadItemPool}} for this.}
}
\value{
An \code{\linkS4class{item_attrib}} object.
}
\description{
Read item attributes from specified file.
}
\examples{
## Write to tempdir() and clean afterwards
f <- file.path(tempdir(), "itempool_science.csv")
write.csv(itempool_science_raw, f, row.names = FALSE)
itempool_science <- loadItemPool(f)
file.remove(f)

f <- file.path(tempdir(), "itemattrib_science.csv")
write.csv(itemattrib_science_raw, f, row.names = FALSE)
itemattrib_science <- loadItemAttrib(f, itempool_science)
file.remove(f)

}
\seealso{
\link{dataset_science} for example usage.
}
