% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difftime_ext.R
\name{units_difftime<-}
\alias{units_difftime<-}
\title{Set \link[base]{units} of \link[base]{difftime} Objects}
\usage{
units_difftime(x) <- value
}
\arguments{
\item{x}{\link[base]{difftime} object}

\item{value}{\link[base]{character} scalar, choice of unit}
}
\value{
Function \link{units_difftime<-} returns a \link[base]{difftime} object.
}
\description{
Set \link[base]{units} of \link[base]{difftime} objects,
with additional support of \code{'months'} and \code{'years'}.
}
\details{
Function \link{units_difftime<-} supports \code{'months'} and \code{'years'}
in addition to \code{'secs'}, \code{'mins'}, \code{'hours'}, \code{'days'}, \code{'weeks'}
supported in function \link[base]{units<-.difftime}.
}
\examples{
(x = Sys.Date() - as.Date('2021-01-01'))
tryCatch(units(x) <- 'months', error = identity)
units_difftime(x) <- 'months'; x
units_difftime(x) <- 'years'; x

}
\keyword{internal}
