% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.by.int.R
\name{sample.by.int}
\alias{sample.by.int}
\title{Indices of Stratified Sampling}
\usage{
sample.by.int(f, ...)
}
\arguments{
\item{f}{\link[base]{factor}}

\item{...}{potential parameters of \link[base]{sample.int}}
}
\value{
Function \link{sample.by.int} returns an \link[base]{integer} \link[base]{vector}.
}
\description{
Indices of Stratified Sampling
}
\details{
End user should use \link[base]{interaction} to combine multiple \link[base]{factor}s.
}
\examples{
id1 = sample.by.int(state.region, size = 2L)
state.region[id1]

id2 = sample.by.int(f = with(npk, interaction(N, P)), size = 2L)
npk[id2, c('N', 'P')] # each combination selected 2x

}
\seealso{
\code{dplyr::slice_sample}
}
