% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-aic-cauchy.R
\name{util_cauchy_aic}
\alias{util_cauchy_aic}
\title{Calculate Akaike Information Criterion (AIC) for Cauchy Distribution}
\usage{
util_cauchy_aic(.x)
}
\arguments{
\item{.x}{A numeric vector containing the data to be fitted to a Cauchy
distribution.}
}
\value{
The AIC value calculated based on the fitted Cauchy distribution to the
provided data.
}
\description{
This function estimates the parameters of a Cauchy distribution from the
provided data using maximum likelihood estimation, and then calculates the
AIC value based on the fitted distribution.
}
\details{
This function calculates the Akaike Information Criterion (AIC) for a Cauchy
distribution fitted to the provided data.

This function fits a Cauchy distribution to the provided data using maximum
likelihood estimation. It first estimates the initial parameters of the
Cauchy distribution using the method of moments. Then, it optimizes the
negative log-likelihood function using the provided data and the initial
parameter estimates. Finally, it calculates the AIC value based on the
fitted distribution.

Initial parameter estimates: The function uses the method of moments estimates
for the initial location and scale parameters of the Cauchy distribution.

Optimization method: The function uses the optim function for optimization.
You might explore different optimization methods within optim for potentially
better performance.

Goodness-of-fit: While AIC is a useful metric for model comparison, it's
recommended to also assess the goodness-of-fit of the chosen model using
visualization and other statistical tests.
}
\examples{
# Example 1: Calculate AIC for a sample dataset
set.seed(123)
x <- rcauchy(30)
util_cauchy_aic(x)

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{convert_to_ts}()},
\code{\link{quantile_normalize}()},
\code{\link{tidy_mcmc_sampling}()},
\code{\link{util_beta_aic}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_f_aic}()},
\code{\link{util_gamma_aic}()},
\code{\link{util_generalized_beta_aic}()},
\code{\link{util_generalized_pareto_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_inverse_burr_aic}()},
\code{\link{util_inverse_pareto_aic}()},
\code{\link{util_inverse_weibull_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_lognormal_aic}()},
\code{\link{util_negative_binomial_aic}()},
\code{\link{util_normal_aic}()},
\code{\link{util_paralogistic_aic}()},
\code{\link{util_pareto1_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_poisson_aic}()},
\code{\link{util_t_aic}()},
\code{\link{util_triangular_aic}()},
\code{\link{util_uniform_aic}()},
\code{\link{util_weibull_aic}()},
\code{\link{util_zero_truncated_binomial_aic}()},
\code{\link{util_zero_truncated_geometric_aic}()},
\code{\link{util_zero_truncated_negative_binomial_aic}()},
\code{\link{util_zero_truncated_poisson_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
