% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est-param-f.R
\name{util_f_param_estimate}
\alias{util_f_param_estimate}
\title{Estimate F Distribution Parameters}
\usage{
util_f_param_estimate(.x, .auto_gen_empirical = TRUE)
}
\arguments{
\item{.x}{The vector of data to be passed to the function, where the data
comes from the \code{rf()} function.}

\item{.auto_gen_empirical}{This is a boolean value of TRUE/FALSE with default
set to TRUE. This will automatically create the \code{tidy_empirical()} output
for the \code{.x} parameter and use the \code{tidy_combine_distributions()}. The user
can then plot out the data using \verb{$combined_data_tbl} from the function output.}
}
\value{
A tibble/list
}
\description{
Estimate F Distribution Parameters
}
\details{
This function will attempt to estimate the F distribution parameters
given some vector of values produced by \code{rf()}. The estimation method
is from the NIST Engineering Statistics Handbook.
}
\examples{
library(dplyr)
library(ggplot2)

set.seed(123)
x <- rf(100, df1 = 5, df2 = 10, ncp = 1)
output <- util_f_param_estimate(x)

output$parameter_tbl

output$combined_data_tbl |>
  tidy_combined_autoplot()

}
\seealso{
Other Parameter Estimation: 
\code{\link{util_bernoulli_param_estimate}()},
\code{\link{util_beta_param_estimate}()},
\code{\link{util_binomial_param_estimate}()},
\code{\link{util_burr_param_estimate}()},
\code{\link{util_cauchy_param_estimate}()},
\code{\link{util_chisquare_param_estimate}()},
\code{\link{util_exponential_param_estimate}()},
\code{\link{util_gamma_param_estimate}()},
\code{\link{util_generalized_beta_param_estimate}()},
\code{\link{util_generalized_pareto_param_estimate}()},
\code{\link{util_geometric_param_estimate}()},
\code{\link{util_hypergeometric_param_estimate}()},
\code{\link{util_inverse_burr_param_estimate}()},
\code{\link{util_inverse_pareto_param_estimate}()},
\code{\link{util_inverse_weibull_param_estimate}()},
\code{\link{util_logistic_param_estimate}()},
\code{\link{util_lognormal_param_estimate}()},
\code{\link{util_negative_binomial_param_estimate}()},
\code{\link{util_normal_param_estimate}()},
\code{\link{util_paralogistic_param_estimate}()},
\code{\link{util_pareto1_param_estimate}()},
\code{\link{util_pareto_param_estimate}()},
\code{\link{util_poisson_param_estimate}()},
\code{\link{util_t_param_estimate}()},
\code{\link{util_triangular_param_estimate}()},
\code{\link{util_uniform_param_estimate}()},
\code{\link{util_weibull_param_estimate}()},
\code{\link{util_zero_truncated_binomial_param_estimate}()},
\code{\link{util_zero_truncated_geometric_param_estimate}()},
\code{\link{util_zero_truncated_negative_binomial_param_estimate}()},
\code{\link{util_zero_truncated_poisson_param_estimate}()}

Other F Distribution: 
\code{\link{tidy_f}()},
\code{\link{util_f_stats_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{F Distribution}
\concept{Parameter Estimation}
