% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-aic-zt-binom.R
\name{util_zero_truncated_binomial_aic}
\alias{util_zero_truncated_binomial_aic}
\title{Calculate Akaike Information Criterion (AIC) for Zero-Truncated Binomial Distribution}
\usage{
util_zero_truncated_binomial_aic(.x)
}
\arguments{
\item{.x}{A numeric vector containing the data (non-zero counts) to be
fitted to a ZTB distribution.}
}
\value{
The AIC value calculated based on the fitted ZTB distribution to
the provided data.
}
\description{
This function estimates the parameters (\code{size} and \code{prob}) of a ZTB
distribution from the provided data using maximum likelihood estimation
(via the \code{optim()} function), and then calculates the AIC value based on the
fitted distribution.
}
\details{
This function calculates the Akaike Information Criterion (AIC) for a
zero-truncated binomial (ZTB) distribution fitted to the provided data.

\strong{Initial parameter estimates:} The choice of initial values for \code{size}
and \code{prob} can impact the convergence of the optimization. Consider using
prior knowledge or method of moments estimates to obtain reasonable starting
values.

\strong{Optimization method:} The default optimization method used is
"L-BFGS-B," which allows for box constraints to keep the parameters within
valid bounds. You might explore other optimization methods available in
\code{optim()} for potentially better performance or different constraint
requirements.

\strong{Data requirements:} The input data \code{.x} should consist of non-zero counts,
as the ZTB distribution does not include zero values. Additionally, the
values in \code{.x} should be less than or equal to the estimated \code{size} parameter.

\strong{Goodness-of-fit:} While AIC is a useful metric for model comparison, it's
recommended to also assess the goodness-of-fit of the chosen ZTB model using
visualization (e.g., probability plots, histograms) and other statistical
tests (e.g., chi-square goodness-of-fit test) to ensure it adequately
describes the data.
}
\examples{

# Example data
set.seed(123)
x <- tidy_zero_truncated_binomial(30, .size = 10, .prob = 0.4)[["y"]]

# Calculate AIC
util_zero_truncated_binomial_aic(x)

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{convert_to_ts}()},
\code{\link{quantile_normalize}()},
\code{\link{tidy_mcmc_sampling}()},
\code{\link{util_beta_aic}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_cauchy_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_f_aic}()},
\code{\link{util_gamma_aic}()},
\code{\link{util_generalized_beta_aic}()},
\code{\link{util_generalized_pareto_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_inverse_burr_aic}()},
\code{\link{util_inverse_pareto_aic}()},
\code{\link{util_inverse_weibull_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_lognormal_aic}()},
\code{\link{util_negative_binomial_aic}()},
\code{\link{util_normal_aic}()},
\code{\link{util_paralogistic_aic}()},
\code{\link{util_pareto1_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_poisson_aic}()},
\code{\link{util_t_aic}()},
\code{\link{util_triangular_aic}()},
\code{\link{util_uniform_aic}()},
\code{\link{util_weibull_aic}()},
\code{\link{util_zero_truncated_geometric_aic}()},
\code{\link{util_zero_truncated_negative_binomial_aic}()},
\code{\link{util_zero_truncated_poisson_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
