% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{coefse}
\alias{coefse}
\title{Extracts the standard errors computed for each cateogry for the 'Adapted Paik et al.' Model}
\usage{
coefse(object)
}
\arguments{
\item{object}{An S3 object of class \code{AdPaik}, returned by the main model function
(\code{AdPaikModel}). This object contains all the optimal parameter estimates.}
}
\value{
A named list containing the categories of the standard errors for the optimal parameters.
}
\description{
Extracts the standard errors for \eqn{\boldsymbol{\phi}}, \eqn{\boldsymbol{\beta}}, \eqn{\mu_1},
\eqn{\nu}, \eqn{\boldsymbol{\gamma}} obtained with the
time-dependent frailty model proposed in the 'Adapted Paik et al.' framework.
}
\details{
The \code{coefse} function extracts the standard errors for the estimated parameters from the
\code{StandardErrorParameters} field in \code{object}.

The function validates the structure of \code{object} and ensures compatibility
with the expected model output. It throws an error if the object is malformed or
inconsistent.
}
\examples{
# Example using the 'Academic Dropout' dataset
data(data_dropout)

# Define the formula and time axis for the model
formula <- time_to_event ~ Gender + CFUP + cluster(group)
time_axis <- c(1.0, 1.4, 1.8, 2.3, 3.1, 3.8, 4.3, 5.0, 5.5, 5.8, 6.0)
eps <- 1e-10
categories_range_min <- c(-8, -2, eps, eps, eps)
categories_range_max <- c(-eps, 0, 1 - eps, 1, 10)

\donttest{
# Run the main model
result <- AdPaikModel(formula, data_dropout, time_axis,
                      categories_range_min, categories_range_max, TRUE)

# Extract the coefficients
coefse(result)
}
}
