% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_classes.R
\name{lnormprior}
\alias{lnormprior}
\title{lnormprior - create a lognormal prior.}
\usage{
lnormprior(mean = 0, sd = 1, lb = -100, ub = 100)
}
\arguments{
\item{mean}{log-mean of the prior distribution.}

\item{sd}{log-sd of the prior distribution.}

\item{lb}{lower bound on the distribution. Necessary for the optimization algorithms, 
To make sure it is a fully normal prior, make lb small relative to the mean/sd.}

\item{ub}{Upper bound on the distribution. Necessary for the optimization algorithms, 
To make sure it is a fully normal prior, make ub large relative to the mean/sd.}
}
\value{
a normal prior model object
This object essentially a vector with
the first element as 2 (for log-normal), the second element the mean, the third
element the log-variance, the fourth and fifth elements the lower and upper bounds, respectively.
}
\description{
Specify a log-normal prior for a ToxicR Bayesian model fit.
}
\examples{
 # Log-Normal Prior with mean 0,sd-1
 lnormprior(mean = 0, sd = 1, lb = -1e4, ub=1e4)

 # Truncated Log-Normal prior, Truncated below at 1
 lnormprior(mean = 0, sd = 1, lb = 1, ub=1e4)
 
}
