\name{seqmpos}
\alias{seqmpos}
\title{Number of matching positions between two sequences.}
\description{
Returns the number of common elements, ie same states appearing at the same position in the two sequences.
}
\usage{
 seqmpos(seq1, seq2, with.miss=FALSE)
}
\arguments{
  \item{seq1}{a sequence from a sequence object.}
  \item{seq2}{a sequence from a sequence object.}
  \item{with.miss}{if \code{TRUE}, gaps appearing at the same position in both sequences are also considedered as common elements}.
}
\seealso{
 \code{}.
}
\examples{
data(famform)
famform.seq <- seqdef(famform)

seqmpos(famform.seq[1,],famform.seq[2,])
seqmpos(famform.seq[2,],famform.seq[4,])

## Example with gaps in sequences
a <- c(NA,"A",NA,"B","C")
b <- c(NA,"C",NA,"B","C")

ex1.seq <- seqdef(rbind(a,b))

seqmpos(ex1.seq[1,], ex1.seq[2,])
seqmpos(ex1.seq[1,], ex1.seq[2,], with.miss=TRUE)

}
\keyword{misc}
