% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bond.R
\name{BondFuture-class}
\alias{BondFuture}
\title{Bond Future Class}
\arguments{
\item{Notional}{The notional amount of the trade}

\item{MTM}{The mark-to-market valuation of the trade}

\item{Currency}{The currency set that the trade belongs to}

\item{Si}{The number of years that the trade will take to start (zero if already started)}

\item{Ei}{The number of years that the trade will expire}

\item{BuySell}{Takes the values of either 'Buy' or 'Sell'}

\item{yield}{The yield of the Underlying Bond}

\item{isin}{The ISIN of the Underlying Bond,}

\item{payment_frequency}{the frequency that the bond pays coupon (Quarter, SA etc)}

\item{maturity_date}{the maturity date of the bond}

\item{coupon_type}{The coupon type of the bond (fixed, floating, flipper etc)}

\item{Issuer}{The issuer of the bond}
}
\value{
An object of type Bond
}
\description{
Creates a Bond Future object with the relevant info needed to calculate the Exposure-at-Default (EAD)
}
\examples{


tr1 = BondFuture(Notional=10000,MtM=30,Currency="EUR",Si=0,Ei=10,BuySell='Buy',
payment_frequency="SA",coupon_type="Fixed",Issuer="CountryA",ISIN = "XS0943423")
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}

