% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AngularDistance.R
\name{AngularDistance}
\alias{AngularDistance}
\title{Angular distance metrics}
\usage{
AngularDistance(returns_matrix, long_short = FALSE)
}
\arguments{
\item{returns_matrix}{a matrix containing the track records of the underlying assets/strategies.}

\item{long_short}{a boolean value which results in the sign of the correlation being ignored, default value is FALSE}
}
\value{
A matrix containing the angular distance values.
}
\description{
Calculates the angular distance between a matrix of the track records of various assets/strategies. The sign of the correlation can be ignored for long/short portfolios.
}
\examples{

## calling AngularDistance() without an argument loads the historical edhec data
##  for the "Short Selling" and "Convertible Arbitrage" strategies
returns_matrix = PerformanceAnalytics::edhec[,c("Short Selling","Convertible Arbitrage")]
angular_distance = AngularDistance(returns_matrix, long_short=FALSE)

}
\references{
Lopez de Prado, Marcos, Codependence (Presentation Slides) (January 2, 2020). Available at SSRN: https://ssrn.com/abstract=3512994
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
