% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Credit.R
\docType{class}
\name{CDOTranche-class}

\alias{CDOTranche}
\title{CDO tranche Class}
\arguments{
\item{Notional}{The notional amount of the trade}

\item{MTM}{The mark-to-market valuation of the trade}

\item{Currency}{The currency set that the belongs}

\item{Si}{The number of years after which the trade will start (zero if already started)}

\item{Ei}{The number of years that the trade will expire}

\item{BuySell}{Takes the values of either 'Buy' or 'Sell'}

\item{attach_point}{The attachment point of the tranche}

\item{detach_point}{The detachment point of the tranche}
}
\value{
An object of type CDOTrance
}
\description{
Creates a CDO tranche Object with the relevant info needed to calculate the Exposure-at-Default (EAD)
}

\examples{

## a CDO trance object
tr3 = CDOTranche(Notional=10000,MtM=0,Currency="USD",Si=0,Ei=5,
BuySell='Buy',SubClass='IG',RefEntity='CDX.IG',cdo_attach_point=0.3 ,cdo_detach_point=0.5)
}
