% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci-ri.R
\name{Consistency}
\alias{Consistency}
\title{Consistency / retention 'indices'}
\usage{
Consistency(dataset, tree, compress = FALSE)
}
\arguments{
\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class
\code{phyDat}, whose names correspond to the labels of any accompanying tree.}

\item{tree}{A tree of class \code{\link{phylo}}.}

\item{compress}{Logical specifying whether to retain the compression of a
\code{phyDat} object or to return a vector specifying to each individual
character, decompressed using the dataset's \code{index} attribute.}
}
\value{
\code{Consistency()} returns a named vector specifying the
consistency index (\code{ci}),
retention index (\code{ri}), and rescaled consistency index (\code{rc}).
}
\description{
\code{Consistency()} calculates the so-called consistency and retention 'indices'
for each character in a dataset, given a bifurcating tree.
Although there is not a straightforward interpretation of these indices,
they are sometimes taken as an indicator of the fit of a character to a
tree.  Values correlate with the number of species sampled and the
distribution of taxa between character states, so are not strictly comparable
between characters in which these factors differ.
}
\details{
#TODO: Retention index not yet implemented.
}
\examples{
data(inapplicable.datasets)
dataset <- inapplicable.phyData[[4]]
Consistency(dataset, TreeTools::NJTree(dataset))
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
