% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/te_stats_glm_logit.R
\name{stats_glm_logit}
\alias{stats_glm_logit}
\title{Fit outcome models using \code{stats::glm}}
\usage{
stats_glm_logit(save_path)
}
\arguments{
\item{save_path}{Directory to save models. Set to \code{NA} if models should not be saved.}
}
\value{
An object of class \code{te_stats_glm_logit} inheriting from \linkS4class{te_model_fitter} which is used for
dispatching methods for the fitting models.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Specify that the pooled logistic regression outcome models should be fit using \link[stats:glm]{stats::glm} with \code{family = binomial(link = "logit")}.

Outcome models additional calculate robust variance estimates using \code{sandwich::vcovCL}.
}
\examples{
stats_glm_logit(save_path = tempdir())
}
\seealso{
Other model_fitter: 
\code{\link{parsnip_model}()},
\code{\link{te_model_fitter-class}}
}
\concept{model_fitter}
