% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfqRestructure.R
\name{lfqRestructure}
\alias{lfqRestructure}
\title{Restructuring of length frequency data (ELEFAN 0)}
\usage{
lfqRestructure(param, MA = 5, addl.sqrt = FALSE)
}
\arguments{
\item{param}{a list consisting of following parameters:
\itemize{
  \item \strong{midLengths} midpoints of the length classes,
  \item \strong{dates} dates of sampling times (class Date),
  \item \strong{catch} matrix with catches/counts per length class (row) and sampling date (column);
}}

\item{MA}{number indicating over how many length classes the moving average should be performed (default: 5)}

\item{addl.sqrt}{additional squareroot transformation of positive values according to Brey et al. (1988)
(default: FALSE).
Particularly useful if many observations have a low frequency (<10).}
}
\value{
A list with the input parameters and following list objects:
\itemize{
  \item \strong{samplingPeriod}: length of sampling period in years,
  \item \strong{samplingDays}: time of sampling times in relation to first sampling time,
  \item \strong{delta_t}: array with time differences between relative sampling time set to zero and
     other sampling times,
  \item \strong{rcounts}: restructured frequencies,
  \item \strong{peaks_mat}: matrix with positive peaks with distinct values,
  \item \strong{ASP}: available sum of peaks, sum of posititve peaks which could be potential be hit by
     growth curves;
}
}
\description{
First step of the Electronic LEngth Frequency ANalysis (ELEFAN), which is restructuring
   length-frequency data (lfq). This is done according to a certain protocol, described by many authors (see
   References for more information).
}
\details{
This function is used in the analysis of growth parameters with the \code{\link{ELEFAN}} function. It is often
   referred to as ELEFAN 0.
}
\examples{
data(trout)
lfqRestructure(param = trout)

}
\references{
Brey, T., Soriano, M., and Pauly, D. 1988. Electronic length frequency analysis: a revised and expanded
user's guide to ELEFAN 0, 1 and 2.

Pauly, D. 1981. The relationship between gill surface area and growth performance in fish:
a generalization of von Bertalanffy's theory of growth. \emph{Meeresforsch}. 28:205-211

Pauly, D. and N. David, 1981. ELEFAN I, a BASIC program for the objective extraction of
growth parameters from length-frequency data. \emph{Meeresforschung}, 28(4):205-211

Pauly, D., 1985. On improving operation and use of ELEFAN programs. Part I: Avoiding
"drift" of K towards low values. \emph{ICLARM Conf. Proc.}, 13-14

Pauly, D., 1987. A review of the ELEFAN system for analysis of length-frequency data in
fish and aquatic invertebrates. \emph{ICLARM Conf. Proc.}, (13):7-34

Pauly, D. and G. R. Morgan (Eds.), 1987. Length-based methods in fisheries research.
(No. 13). WorldFish

Pauly, D. and G. Gaschuetz. 1979. A simple method for fitting oscillating length growth data, with a
program for pocket calculators. I.C.E.S. CM 1979/6:24. Demersal Fish Cttee, 26 p.

Pauly, D. 1984. Fish population dynamics in tropical waters: a manual for use with programmable
calculators (Vol. 8). WorldFish.

Quenouille, M. H., 1956. Notes on bias in estimation. \emph{Biometrika}, 43:353-360

Somers, I. F., 1988. On a seasonally oscillating growth function. ICLARM Fishbyte 6(1): 8-11.

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2): 407 p.

Tukey, J., 1958. Bias and confidence in not quite large samples.
\emph{Annals of Mathematical Statistics}, 29: 614

Tukey, J., 1986. The future of processes of data analysis. In L. V. Jones (Eds.),
The Collected Works of John W. Tukey-philosophy and principles of data analysis:
1965-1986 (Vol. 4, pp. 517-549). Monterey, CA, USA: Wadsworth & Brooks/Cole
}

