% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VPA.R
\name{VPA}
\alias{VPA}
\title{Virtual Population Analysis (VPA)}
\usage{
VPA(param, terminalF, analysis_type, catch_corFac = NA, catch_columns = NA,
  algorithm = "new", plus_group = FALSE, plot = FALSE)
}
\arguments{
\item{param}{a list consisting of following parameters:
\itemize{
  \item \code{midLengths} or \code{age}: midpoints of the length class
  (length-frequency data) or ages (age composition data),
  \item \code{Linf}: infinite length for investigated species in cm [cm],
  \item \code{K}: growth coefficent for investigated species per year [1/year],
  \item \code{t0}: theoretical time zero, at which individuals of this species hatch,
  \item \code{M}: natural mortality [1/year],
  \item \code{a}: length-weight relationship coefficent (W = a * L^b),
  \item \code{b}: length-weight relationship coefficent (W = a * L^b),
  \item \code{catch}: catch as vector for pseudo cohort analysis,
     or a matrix with catches of subsequent years to follow a real cohort;
}}

\item{terminalF}{a fishing mortality value which is used as the terminal FM for the
last age/length group.}

\item{analysis_type}{determines which type of assessment should be done,
options: "VPA" for classical age-based VPA, "CA" for age- or length-based
Cohort analysis}

\item{catch_corFac}{optional; correction factor for catch, in case provided
catch does spatially or temporarily not reflect catch for fishing ground of
a whole year.}

\item{catch_columns}{numerical; indicating the column of the catch matrix which should be
used for the analysis.}

\item{algorithm}{an Algorithm to use to solve for fishing mortality. The default
setting \code{"new"} uses \code{\link[stats]{optimise}},
while \code{"old"} uses the algorithm described by Sparre and Venema (1998).}

\item{plus_group}{logical; indicating if the last length group is a plus group}

\item{plot}{logical; indicating whether a plot should be printed}
}
\value{
A list with the input parameters and following list objects:
\itemize{
  \item \strong{classes.num}: numeric age classes or length groups (without plus sign),
  \item \strong{catch.cohort}: a vector with the catch values which were used for
  the analysis (exists only if catch was a matrix),
  \item \strong{FM_calc}: a vector with the ifshing mortality (M),
  \item \strong{Z}: a vector with the total mortality (Z),
  \item \strong{survivors}: a vector with the number of fish surviving to the next age class or length group,
  \item \strong{annualMeanNr}: ta vector with the mean number of fish per year,
  \item \strong{meanBodyWeight}: a vector with the mean body weight in kg,
  \item \strong{meanBiomassTon}: a vector with the mean biomass in tons,
  \item \strong{YieldTon}: a vector with the yield in tons,
  \item \strong{natLoss}: a vector with the number of fish died due
  to natural mortality,
  \item \strong{plot_mat}: matrix with rearranged survivors, nat losses
  and catches for plotting;
}
}
\description{
This function applies the Virtual Population Analysis (VPA) or
   Cohort analysis (CA). Methods used to estimate stock biomass and fishing
   mortality per age/length group.
}
\details{
The main difference between virtual population analysis (VPA) and cohort
   analysis (CA) is the step of calculating the fishing mortality per age class or
   length group. While CA works with an approximation by assuming that all fish are
   caught during a single day, which makes the calcualtion easier, VPA assumes that
   the fish are caught continuously, which has to be solved by the trial and error
   method (Sparre and Venema, 1998).
   The catch has to be representative for fished species, that means there should not be
   other fisheries fishing the same stock. If this is the case \code{catch_corFac} can
   be used as a raising factor to account for the proportion of fish caught by other
   fisheries.
   When the model should follow a real cohort instead of a pseudo cohort, \code{catch}
   has to be provided as matrix. The model then starts to follow the first age class
   in the first column.
   If \code{catch} matrix is shorter than the number of age classes, the age or length
   classes without catch information are omitted. It is recommended to only
   follow a real cohort if there is enough information for all age classes
   (test with: \code{dim(catch)[1] <= dim(catch)[2]}).
   If \code{plus_group} is TRUE a different calculation for the survivors of the last length group
   is used (for more details please refer to Sparre & Venema (1998)).
}
\examples{
#_______________________________________________
# Virtual Popuation Analysis with age-composition data
data(whiting)
output <- VPA(param = whiting, terminalF = 0.5, analysis_type = "VPA")
plot(output)
#_______________________________________________
# Pope's Cohort Analysis with age-composition data
data(whiting)
VPA(whiting, terminalF = 0.5, analysis_type = "CA", plot= TRUE)

#_______________________________________________
# Jones's Cohort Analysis with length-composition data
data(hake)
VPA(hake, terminalF = 0.5, analysis_type = "CA", plot = TRUE)

}
\references{
Jones, R., 1984. Assessing the effects of changes in exploitation pattern using length
composition data (with notes on VPA and cohort analysis). \emph{FAO Fish.Tech.Pap.},
(256): 118p.

Jones, R., 1990. Length-cohort analysis: the importance of choosing the correct growth
parameters. \emph{Journal du Conseil: ICES Journal of Marine Science}, 46(2), 133-139

Pope, J.G., 1972. An investigation of the accuracy of virtual population analysis using
cohort analysis. \emph{Res.Bull.ICNAF}, (9):65-74

Pope, J.G., 1979. A modified cohort analysis in which constant natural mortality is
replaced by estimates of predation levels. \emph{ICES C.M.} 1979/H:16:7p. (mimeo)

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.

References for weight-length relationship parameters (a & b):
Dorel, D., 1986. Poissons del'Atlantique nord-est relations taille-poids.
Institut Francais de Recherche pour l'Exploitation de la Mer. Nantes, France. 165 p.
}
\keyword{F}
\keyword{VPA}
\keyword{biomass}
\keyword{cohort}
\keyword{function}
\keyword{mortality}
\keyword{stock}

