% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stock_sim.R
\name{stock_sim}
\alias{stock_sim}
\title{Stock simulation}
\usage{
stock_sim(param, age_unit = "year", stock_size_1 = NA, plus_group = NA)
}
\arguments{
\item{param}{a list consisting of following parameters:
\itemize{
  \item \code{age} or \code{midLengths}: midpoints of length classes (length-frequency
  data) or ages (age composition data),
  \item \code{meanWeight}: mean weight in kg per age class or length group,
  \item \code{meanValue}: mean value per kg fish per age class or length group,
  \item \code{FM}: fishing mortality rates per age class or length group,
  \item \code{M} or \code{Z}: natural or total instantaneous mortality rate.
}}

\item{age_unit}{indicates if the age groups are per month (\code{"month"}) or
per year (\code{"year"}). Default: \code{"year"}}

\item{stock_size_1}{stock size of smallest age/length group}

\item{plus_group}{indicates age/length group, which should be turned into a plus
group (i.e. all groups above are comprised in one group)}
}
\value{
A list with the input parameters and following list objects:
\itemize{
  \item \strong{dt}: delta t,
  \item \strong{N}: population numbers,
  \item \strong{dead}: number of deaths due to natural mortality,
  \item \strong{C}: catch,
  \item \strong{Y}: yield,
  \item \strong{B}: biomass,
  \item \strong{V}: value,
  \item \strong{totals}: summarised output:
  \itemize{
  \item \strong{totC} total catch,
  \item \strong{totY} total yield,
  \item \strong{totV} total value,
  \item \strong{meanB} mean biomass.
  },
}
}
\description{
This function estimates stock size, biomass and yield of a stock from
   fishing mortality per age class or length group. This function is embedded in the
   Thompson and Bell model (prediction model: \code{\link{predict_mod}}).
}
\details{
better to treat last group always as a plus group...
     if stock size 1 not provided assumes 1000 as intital population size
     make sure that FM is also in same unit as the classes, e.g. when classes in
     months than also FM has to be provided in 1/months
}
\examples{
# age-based stock simulation
data(shrimps)

# option 1: without plus group
stock_sim(shrimps, age_unit = "month")

# option 2: with plus group
stock_sim(param = shrimps, age_unit = "month", plus_group = 11)

# length-based stock simulation
data(hake)

stock_sim(param = hake, stock_size_1 = 98919.3)

}
\references{
Garcia, S. and N.P. van Zalinge, 1982. Shrimp fishing in Kuwait: methodology
   for a joint analysis of the artisanal and industrial fisheries. pp. 119-142 In:
   Report on the Workshop on assessment of the shrimp stocks of the west coast of
   the Gulf between Iran and the Arabian Peninsula. Fisheries development in the
   Gulf. Rome, FAO, FI:DP/RAB/80/015/1, 163 p.

Millar, R. B., & Holst, R. (1997). Estimation of gillnet and hook selectivity using
log-linear models. \emph{ICES Journal of Marine Science: Journal du Conseil},
54(3):471-477

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.
}
\keyword{function}
\keyword{prediction}
\keyword{ypr}
