% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.r
\name{Download}
\alias{Download}
\title{Download files retryable}
\usage{
Download(
  URLs,
  names = NULL,
  method = NULL,
  sleep = NULL,
  outdir = NULL,
  verbose = TRUE
)
}
\arguments{
\item{URLs}{character/list. URLs to be downloaded.}

\item{names}{character/list. file names. Default \code{seq(URLs)}}

\item{method}{character. Method to be used for downloading files, equal to \code{download.file}. Default 'libcurl'}

\item{sleep}{numeric. retry interval (second). Default 2}

\item{outdir}{character. output directory.}

\item{verbose}{logical. Default TRUE}
}
\value{
if success, return TRUE
}
\description{
Download files retryable
}
\examples{
URLs = paste0('http://www.imgt.org//download/', c('V-QUEST/IMGT_V-QUEST_reference_directory',
         'GENE-DB/IMGTGENEDB-ReferenceSequences.fasta-nt-WithGaps-F+ORF+inframeP'))
\donttest{Download(URLs, c('vdj_species.html', 'IMGT_download.fa'))}

}
