% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XenaFilter.R
\name{XenaFilter}
\alias{XenaFilter}
\title{Filter a XenaHub Object}
\usage{
XenaFilter(
  x,
  filterCohorts = NULL,
  filterDatasets = NULL,
  ignore.case = TRUE,
  ...
)
}
\arguments{
\item{x}{a \link{XenaHub} object}

\item{filterCohorts}{default is \code{NULL}. A character used to filter cohorts,
regular expression is supported.}

\item{filterDatasets}{default is \code{NULL}. A character used to filter datasets,
regular expression is supported.}

\item{ignore.case}{if \code{FALSE}, the pattern matching is case sensitive
and if \code{TRUE}, case is ignored during matching.}

\item{...}{other arguments except \code{value} passed to \code{\link[base:grep]{base::grep()}}.}
}
\value{
a \code{XenaHub} object
}
\description{
One of main functions in \strong{UCSCXenatools}. It is used to filter
\code{XenaHub} object according to cohorts, datasets. All datasets can be found
at \url{https://xenabrowser.net/datapages/}.
}
\examples{
# operate TCGA datasets
xe = XenaGenerate(subset = XenaHostNames == "tcgaHub")
xe
# get all names of clinical data
xe2 = XenaFilter(xe, filterDatasets = "clinical")
datasets(xe2)
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
