% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCfilter.R
\name{UCdisturb}
\alias{UCdisturb}
\title{UCdisturb}
\usage{
UCdisturb(sys)
}
\arguments{
\item{sys}{an object of type \code{UComp} created with \code{UCmodel}}
}
\value{
The same input object with the appropriate fields 
filled in, in particular:
\item{yFit}{Fitted values of output}
\item{yFitV}{Variance of fitted values of output}
\item{a}{State estimates}
\item{P}{Variance of state estimates}
\item{eta}{State perturbations estimates}
\item{eps}{Observed perturbations estimates}
}
\description{
Runs the Disturbance Smoother for UC models
}
\examples{
m1 <- UCmodel(log(AirPassengers))
m1 <- UCdisturb(m1)
}
\seealso{
\code{\link{UC}}, \code{\link{UCmodel}}, \code{\link{UCvalidate}}, \code{\link{UCfilter}}, 
         \code{\link{UCsmooth}}, \code{\link{UCcomponents}}
}
\author{
Diego J. Pedregal
}
