% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{WeightsUnLcv}
\alias{WeightsUnLcv}
\title{Site ungauged linear coefficient of variation (Lcv) weightings}
\usage{
WeightsUnLcv(x)
}
\arguments{
\item{x}{pooling group derived with the Pool() function}
}
\value{
A data.frame with site references in the first column and associated weights in the second
}
\description{
Provides the ungauged Lcv weights for each site in a pooling group
}
\details{
Weighting method as according to Science Report: SC050050 - Improving the FEH statistical procedures for flood frequency estimation
}
\examples{
#Get some CDs, form an ungauged pooling group, and estimate ungauged Lcv
CDs.96001 <- GetCDs(96001)
Pool.96001 <- Pool(CDs.96001, exclude = 96001)
WeightsUnLcv(Pool.96001)
}
\author{
Anthony Hammond
}
