% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UPCM-package.R
\docType{package}
\name{UPCM-package}
\alias{UPCM-package}
\title{Uncertainty in Partial Credit Models}
\description{
Performs UPCM, a method to model uncertainty in (Generalized) Partial Credit Models
}
\examples{
\donttest{
data(tenseness)

Y <- data.matrix(tenseness[,1:4])
X <- model.matrix(~ Gender + Age, data = tenseness)[,-1]

m_upcm <- UPCM(Y = Y, X = X, cores = 2, GPCM = FALSE)
m_upcm
plot(m_upcm)
}
}
\references{
Tutz, Gerhard and Schauberger, Gunther (2020): Uncertainty in Latent Trait Models, 
\emph{Applied Psychological Measurement}, \url{https://journals.sagepub.com/doi/abs/10.1177/0146621620920932?journalCode=apma}
}
\seealso{
\code{\link{UPCM}}
}
\author{
Gunther Schauberger\cr \email{gunther.schauberger@tum.de}\cr
\url{https://www.sg.tum.de/epidemiologie/team/schauberger/}
}
\keyword{Credit}
\keyword{Model}
\keyword{Partial}
\keyword{UPCM}
\keyword{Uncertainty}
\keyword{package}
