% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LOGLIK.R
\name{logLik.UPG.Probit}
\alias{logLik.UPG.Probit}
\title{Compute log-likelihoods from UPG.Probit objects}
\usage{
\method{logLik}{UPG.Probit}(object = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{UPG.Probit}.}

\item{...}{other logLik parameters.}
}
\value{
Returns a numeric of class \code{logLik} with attributes containing the number of estimated parameters and the number of observations.
}
\description{
\code{logLik} can be used to compute log-likelihoods from \code{UPG.Probit} objects. The log-likelihood is based on the posterior mean of the coefficients and can be used for model selection when combined with,e.g., \code{BIC} or other model selection criteria.
}
\examples{
\donttest{
# estimate a probit model using example data
library(UPG)
data(lfp)
y = lfp[,1]
X = lfp[,-1]
results.probit = UPG(y = y, X = X, type = "probit", verbose=TRUE)

# extract log-likelihood
ll.probit = logLik(results.probit)

# compute BIC
BIC(ll.probit)
}
}
\seealso{
\code{\link{summary.UPG.Probit}} to summarize the estimates of a discrete choice model from an \code{UPG.Probit} object and create tables.
\code{\link{plot.UPG.Probit}} to plot the results of a discrete choice model from an \code{UPG.Probit} object.
\code{\link{coef.UPG.Probit}} to extract coefficients from an \code{UPG.Probit} object.
}
\author{
Gregor Zens
}
