% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanThreeSigRej.R
\name{meanThreeSigRej}
\alias{meanThreeSigRej}
\title{Perform cuts in the data}
\usage{
meanThreeSigRej(vec, maxI, tolerance)
}
\arguments{
\item{vec}{a vector with the data to consider}

\item{maxI}{an integer with the maximum amount of iterations allowed}

\item{tolerance}{a double with the tolerance value (as \code{(old-new)/old})}
}
\value{
A data frame with the fields \code{mean}, \code{sd} (the standard deviation) and \code{convergenceAtIter} (the iteration where the convergence was reached).
}
\description{
\code{meanThreeSigRej} will perform an interative rejection using the mean
and three sigma of the data. The function will compute the mean and standard 
deviation of the input vector, reject all entries lying farther than three-sigma, and 
iterate until the mean varies (fractionaly) by less than the tolerance value. The 
function will return a data frame with the mean, standard deviation value and the 
number of iterations until the convergence was reached.
}
\examples{
# Create a simple data set with the values and errors
toyData <- c(rnorm(30, mean=0, sd=5), 10000, 1000)

# Call the function to perform cuts
toyDataItStat <- meanThreeSigRej(toyData)

cat(paste("True mean             = 0\\n"))
cat(paste("Before rejection mean =",round(mean(toyData),2),"\\n"))
cat(paste("After rejetion mean   =",round(toyDataItStat$mean,2),"\\n"))

# Clean the environment
rm(list=c("toyData", "toyDataItStat"))
 
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\keyword{utilities}
