% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varEst_class3.R
\name{var_Brewer_class3}
\alias{var_Brewer_class3}
\title{Approximate Variance Estimators by Brewer (2002)}
\usage{
var_Brewer_class3(y, pik, method, sample)
}
\arguments{
\item{y}{numeric vector of sample observations}

\item{pik}{numeric vector of first-order inclusion probabilities for all population units}

\item{method}{string indicating the desired approximate variance estimator.
One of "Deville1", "Deville2", "Deville3", "Hajek", "Rosen", "FixedPoint",
"Brewer1", "HartleyRao", "Berger", "Tille", "MateiTille1", "MateiTille2",
"MateiTille3", "MateiTille4", "MateiTille5", "Brewer2", "Brewer3", "Brewer4".}

\item{sample}{Either a numeric vector of length equal to the sample size with
the indices of sample units, or a boolean vector of the same length of \code{pik}, indicating which
units belong to the sample (\code{TRUE} if the unit is in the sample,
\code{FALSE} otherwise.
Only used with estimators of the third class (see Details for more information).}
}
\value{
a scalar, the estimated variance
}
\description{
Compute an approximate variance estimate using the class of estimators
proposed by Brewer (2002).
Estimators of class 3, they require only first-order inclusion probabilities but
for all population units.
}
\keyword{internal}
