% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumbasis.R
\name{sumbasis}
\alias{sumbasis}
\title{Kernel entries in infinite dimensional case}
\usage{
sumbasis(Ntrunc, M, x1, x2)
}
\arguments{
\item{Ntrunc}{The total number of coefficients to look at.}

\item{M}{The maximum frequency to look at in the Fourier basis.}

\item{x1}{The coefficients of the first data point.}

\item{x2}{The coefficients of the second data point.}
}
\value{
The entry of the kernel corresponding to the two data points.
}
\description{
Function to calculate each entry of the kernel matrix in the infinite dimensional
example described in Section 7.4 of \insertCite{BKS2020}{USP}. Here, a random function is converted
to a sequence of coefficients and we use the Fourier basis on these coefficients. This
function is only used in the function InfKern.
}
\examples{
x1=runif(5); x2=runif(5); sumbasis(5,2,x1,x2)
}
\references{
\insertRef{BKS2020}{USP}
}
