% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{US_source}
\alias{US_source}
\title{The US Hourly Net Generation by Energy Source}
\format{A tsibble object with hourly intervals}
\source{
US Energy Information Administration (Dec 2019) \href{https://www.eia.gov/}{website}
}
\usage{
US_source
}
\description{
The net generation of electricity in the US by energy source (i.e., natural gas, coal, solar, etc.) since July 2018.

Units: megawatthours

Time zone: UTC
}
\details{
The dataset contains the hourly net generation of electricity in the US (megawatthours) by energy source
The `source` column describes the type of the energy source
}
\examples{

data(US_source)

library(plotly)

plot_ly(data = US_source,
        x = ~ date_time,
        y = ~ series,
        color = ~ source,
        type = "scatter",
        mode = "lines")

}
\keyword{datasets}
\keyword{time-series}
