% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_LpS.R
\name{first.step.detect}
\alias{first.step.detect}
\title{First step rolling window function}
\usage{
first.step.detect(
  data,
  h,
  step.size = NULL,
  lambda,
  mu,
  alpha_L = 0.25,
  skip = 3,
  lambda.1.seq = NULL,
  mu.1.seq = NULL,
  cv = FALSE,
  nfold = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data}{the whole data matrix}

\item{h}{window size}

\item{step.size}{rolling step size, default is NULL. If Null, the step size is 1/4 of the window size}

\item{lambda}{a 2-d vector of tuning parameters for sparse components, available when cv is FALSE}

\item{mu}{a 2-d vector of tuning parameters for low rank components, available when cv is FALSE}

\item{alpha_L}{a numeric value, indicates the size of constraint space of low rank component}

\item{skip}{the number of observations we should skip near the boundaries, default is 3}

\item{lambda.1.seq}{the sequence of sparse tuning parameter to the left segment, only available when cv is TRUE}

\item{mu.1.seq}{the sequence of low rank tuning, only available for cv is TRUE}

\item{cv}{a boolean argument, indicates whether use cross validation or not}

\item{nfold}{a positive integer, indicates the number of folds of cross validation}

\item{verbose}{if TRUE, then all information for current stage are printed}
}
\value{
A vector which includes all candidate change points selected by rolling window
}
\description{
Rolling window scheme function for the first step
}
